import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
    newReview: {},
    loading: false,
};

export const postReview = createAsyncThunk("user/postReview", async (obj) => {
    try {
        const { access_token, URL, method, formData } = obj;
        const data = await mutationResponse(
            URL,
            method,
            formData,
            access_token
        );
        return data;
    } catch (err) {
        return;
    }
});

const postReviewSlice = createSlice({
    name: "user",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(postReview.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(postReview.fulfilled, (state, { payload }) => {
            state.newReview = payload;
            state.loading = false;
        });
        builder.addCase(postReview.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default postReviewSlice.reducer;
